

#define OPPC_SPR_MMCR0  952  // supervisor only
#define OPPC_SPR_MMCR1  956  // supervisor only

#define OPPC_SPR_UMMCR0 936
#define OPPC_SPR_UMMCR1 940


#define OPPC_SPR_PMC1  953  // supervisor only
#define OPPC_SPR_PMC2  954  // supervisor only
#define OPPC_SPR_PMC3  957  // supervisor only
#define OPPC_SPR_PMC4  958  // supervisor only

#define OPPC_SPR_UPMC1 937
#define OPPC_SPR_UPMC2 938
#define OPPC_SPR_UPMC3 941
#define OPPC_SPR_UPMC4 942

#define OPPC_SPR_SIA   955  // supervisor only
#define OPPC_SPR_USIA  939

typedef unsigned int OPPCSPR;

#define _OPPC_GET_SPR(value, reg)	\
do {					\
    register OPPCSPR _value;		\
                                        \
    asm volatile (			\
                  "mfspr %0," #reg	\
                  : "=r" (_value)	\
                  :			\
    );					\
                                        \
    (value) = _value;			\
} while (0)

#define OPPC_GET_SPR(value, reg)  _OPPC_GET_SPR(value, reg)

#define _OPPC_SET_SPR(value, reg)	\
do {					\
    register OPPCSPR _value;		\
                                        \
    _value = (value);			\
    asm volatile (			\
                  "mtspr " #reg ",%0"	\
                  :			\
                  : "r" (_value)	\
    );					\
} while (0)

#define OPPC_SET_SPR(value, reg)  _OPPC_SET_SPR(value, reg)


static inline void OPPCSync()
{
    asm volatile("sync");
}

static inline unsigned int OPPCGetPMC1()
{
    unsigned int value;
    OPPC_GET_SPR(value, OPPC_SPR_UPMC1);
    return value;
}
static inline unsigned int OPPCGetPMC2()
{
    unsigned int value;
    OPPC_GET_SPR(value, OPPC_SPR_UPMC2);
    return value;
}
static inline unsigned int OPPCGetPMC3()
{
    unsigned int value;
    OPPC_GET_SPR(value, OPPC_SPR_UPMC3);
    return value;
}
static inline unsigned int OPPCGetPMC4()
{
    unsigned int value;
    OPPC_GET_SPR(value, OPPC_SPR_UPMC4);
    return value;
}

#define OPPC_PMC_GET(values)	\
do {				\
    OPPCSync();			\
    values[0] = OPPCGetPMC1();	\
    values[1] = OPPCGetPMC2();	\
    values[2] = OPPCGetPMC3();	\
    values[3] = OPPCGetPMC4();	\
} while (0)

#define OPPC_PMC_ADD(startValues, sumValues)		\
do {							\
    OPPCSPR endValues[4];				\
							\
    OPPC_PMC_GET(endValues);				\
    sumValues[0] += (endValues[0] - startValues[0]);	\
    sumValues[1] += (endValues[1] - startValues[1]);	\
    sumValues[2] += (endValues[2] - startValues[2]);	\
    sumValues[3] += (endValues[3] - startValues[3]);	\
} while (0)

#if 0
#define OMNI_PPC_TIMER_START \
do { \
    unsigned int ppc_start1, ppc_end1; \
    unsigned int ppc_start2, ppc_end2; \
    unsigned int ppc_start3, ppc_end3; \
    unsigned int ppc_start4, ppc_end4; \
    ppc_count++; \
    OPPCSync(); \
    ppc_start1 = OPPCGetPMC1(); \
    ppc_start2 = OPPCGetPMC2(); \
    ppc_start3 = OPPCGetPMC3(); \
    ppc_start4 = OPPCGetPMC4(); \
    {

#define OMNI_PPC_TIMER_END \
    } \
    OPPCSync(); \
    ppc_end1 = OPPCGetPMC1(); \
    ppc_end2 = OPPCGetPMC2(); \
    ppc_end3 = OPPCGetPMC3(); \
    ppc_end4 = OPPCGetPMC4(); \
    ppc_counter1 += (ppc_end1 - ppc_start1); \
    ppc_counter2 += (ppc_end2 - ppc_start2); \
    ppc_counter3 += (ppc_end3 - ppc_start3); \
    ppc_counter4 += (ppc_end4 - ppc_start4); \
} while(0)
#else

extern void OPPCTimerStart();
extern void OPPCTimerEnd();

#define OMNI_PPC_TIMER_START OPPCTimerStart()
#define OMNI_PPC_TIMER_END   OPPCTimerEnd()

#endif

#define OMNI_PPC_TIMER_CLEAR	\
do {				\
    ppc_count    = 0;		\
    ppc_counter1 = 0;		\
    ppc_counter2 = 0;		\
    ppc_counter3 = 0;		\
    ppc_counter4 = 0;		\
} while(0)
