#import <stdio.h>
#import <stdlib.h>
#import <unistd.h>

#import <OmniTimer/OTTimer.h>

// Serves as a simple example, and a test to make sure the framework is actually
// work properly on the current architecture.

#define DURATION (5)

int main(int argc, char *argv[])
{
    OTStamp start, end, delta;
    
    OTSetup();
    
    OTReadCounter(&start);
    sleep(DURATION);
    OTReadCounter(&end);

    printf("start   = %qu\n", start.ull);
    printf("end     = %qu\n", end.ull);

    OTDeltaTimers(&start, &end, &delta);
    printf("delta   = %qd\n", delta.ull);

    printf("steps per seconds = %f\n", (float)delta.ull / (float)DURATION);
    printf("time = %f\n", OTStampToSeconds(&delta));

    return 0;
}

